'From Squeak3.5 of ''11 April 2003'' [latest update: #5180] on 6 February 2004 at 4:40:46 pm'!
Transcript show: 'PitchResult'; cr!
Smalltalk at: #PitchResult put: Dictionary new!
PitchResult at: #'Ball' put:  2!
PitchResult at: #'Double' put:  6!
PitchResult at: #'Foul' put:  3!
PitchResult at: #'Hitbatter' put:  9!
PitchResult at: #'Homer' put:  8!
PitchResult at: #'NumResults' put:  9!
PitchResult at: #'Out' put:  4!
PitchResult at: #'Single' put:  5!
PitchResult at: #'Strike' put:  1!
PitchResult at: #'Triple' put:  7!

Object subclass: #Pitcher
	instanceVariableNames: 'result rgen weight '
	classVariableNames: ''
	poolDictionaries: 'PitchResult '
	category: 'My Stuff'!


!Pitcher methodsFor: 'initialization' stamp: 'DY 2/5/2004 22:06'!
initialize
weight := Array new: NumResults.
rgen := Rangen new.
weight at: Hitbatter put: 0.005.
weight at: Strike put: 0.25.
weight at: Ball put: 0.3.
weight at: Foul put: 0.2.
weight at: Out put: 0.14.
weight at: Single put: 0.05.
weight at: Double put: 0.03.
weight at: Triple put: 0.02.
weight at: Homer put: 0.005.


! !

!Pitcher methodsFor: 'initialization' stamp: 'DY 2/5/2004 22:16'!
initialize: anInteger
weight := Array new: NumResults.
rgen := Rangen new initialize: anInteger.
weight at: Hitbatter put: 0.005.
weight at: Strike put: 0.25.
weight at: Ball put: 0.3.
weight at: Foul put: 0.2.
weight at: Out put: 0.14.
weight at: Single put: 0.05.
weight at: Double put: 0.03.
weight at: Triple put: 0.02.
weight at: Homer put: 0.005.

! !

!Pitcher methodsFor: 'initialization' stamp: 'DY 2/5/2004 22:29'!
throw
	| resultFraction accumulatedWeight |
	resultFraction := rgen randomFraction.
	accumulatedWeight := weight at: 1.
	result := 1.
	[ resultFraction > accumulatedWeight ] whileTrue: [
		result := result + 1.
		accumulatedWeight := accumulatedWeight + (weight at: result)
	].
	^self
	! !


!Pitcher methodsFor: 'accessing' stamp: 'DY 2/2/2004 23:48'!
pitch
^ result! !

!Pitcher methodsFor: 'accessing' stamp: 'DY 2/3/2004 00:02'!
pitchAsString
	^ result caseOf: {
		[Hitbatter] -> ['hit batter'].
		[Strike] -> ['strike'].
		[Ball] -> ['ball'].
		[Single] -> ['single'].
		[Double] -> ['double'].
		[Triple] -> ['triple'].
		[Homer] -> ['homer'].
		[Out]-> ['out'].
		[Foul] -> ['foul']
	}
	otherwise: ['undefined'].! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Pitcher class
	instanceVariableNames: ''!

!Pitcher class methodsFor: 'as yet unclassified' stamp: 'DY 1/27/2004 15:30'!
new
^ super new initialize! !

!Pitcher class methodsFor: 'as yet unclassified' stamp: 'DY 2/5/2004 21:54'!
new: anInteger
^ super new initialize: anInteger! !
